<?php

namespace Paysera\DeliveryApi\MerchantClient\Entity;

use Paysera\Scoped\Paysera\Component\RestClientCommon\Entity\Entity;
class ProjectCollection extends Entity
{
    public function __construct(array $data = [])
    {
        parent::__construct($data);
    }
    /**
     * @return Project[]
     */
    public function getList()
    {
        $items = $this->getByReference('list');
        if ($items === null) {
            return [];
        }
        $list = [];
        foreach ($items as &$item) {
            $list[] = (new \Paysera\DeliveryApi\MerchantClient\Entity\Project())->setDataByReference($item);
        }
        return $list;
    }
    /**
     * @param Project[] $list
     * @return $this
     */
    public function setList(array $list)
    {
        $data = [];
        foreach ($list as $item) {
            $data[] = $item->getDataByReference();
        }
        $this->setByReference('list', $data);
        return $this;
    }
}
