<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace Paysera\Scoped\Symfony\Component\Validator\Constraints;

/**
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @author Bernhard Schussek <bschussek@gmail.com>
 */
#[\Attribute(\Attribute::TARGET_PROPERTY | \Attribute::TARGET_METHOD | \Attribute::IS_REPEATABLE)]
class All extends Composite
{
    public $constraints = [];
    public function __construct($constraints = null, ?array $groups = null, $payload = null)
    {
        parent::__construct($constraints ?? [], $groups, $payload);
    }
    public function getDefaultOption()
    {
        return 'constraints';
    }
    public function getRequiredOptions()
    {
        return ['constraints'];
    }
    protected function getCompositeOption()
    {
        return 'constraints';
    }
}
