<?php

declare (strict_types=1);
namespace Paysera\Scoped\Paysera\CheckoutSdk\Validator;

use Paysera\Scoped\Paysera\CheckoutSdk\Entity\Collection\ItemInterface;
use Paysera\Scoped\Paysera\CheckoutSdk\Entity\RequestInterface;
use Paysera\Scoped\Paysera\CheckoutSdk\Exception\InvalidTypeException;
use Paysera\Scoped\Paysera\CheckoutSdk\Exception\ValidationException;
interface RequestValidatorInterface extends ItemInterface
{
    public function canValidate(RequestInterface $request) : bool;
    /**
     * @throws InvalidTypeException|ValidationException
     */
    public function validate(RequestInterface $request) : void;
}
