<?php

namespace Paysera\DeliveryApi\MerchantClient\Entity;

use Paysera\Scoped\Paysera\Component\RestClientCommon\Entity\Entity;
class Contact extends Entity
{
    public function __construct(array $data = [])
    {
        parent::__construct($data);
    }
    /**
     * @return Party
     */
    public function getParty()
    {
        return (new \Paysera\DeliveryApi\MerchantClient\Entity\Party())->setDataByReference($this->getByReference('party'));
    }
    /**
     * @param Party $party
     * @return $this
     */
    public function setParty(\Paysera\DeliveryApi\MerchantClient\Entity\Party $party)
    {
        $this->setByReference('party', $party->getDataByReference());
        return $this;
    }
    /**
     * @return Address
     */
    public function getAddress()
    {
        return (new \Paysera\DeliveryApi\MerchantClient\Entity\Address())->setDataByReference($this->getByReference('address'));
    }
    /**
     * @param Address $address
     * @return $this
     */
    public function setAddress(\Paysera\DeliveryApi\MerchantClient\Entity\Address $address)
    {
        $this->setByReference('address', $address->getDataByReference());
        return $this;
    }
}
