<?php

declare(strict_types=1);

use Paysera\Entity\PayseraDeliverySettings;

global $wpdb;

return [
    'wpdb_prefix' => $wpdb->prefix,
    'event.delivery_order.updated' => PayseraDeliverySettings::DELIVERY_ORDER_EVENT_UPDATED,
    'event.wc_order.created' => PayseraDeliverySettings::WC_ORDER_EVENT_CREATED,
    'event.wc_order.paid' => PayseraDeliverySettings::WC_ORDER_EVENT_PAYMENT_COMPLETED,
    'self-diagnosis.php_openssl_compatibility' => [
        '7.0' => ['gte' => '0.9.8', 'lt' => '1.2'],
        '7.1' => ['gte' => '1.0.1', 'lt' => '3.0'],
        '7.2' => ['gte' => '1.0.1', 'lt' => '3.0'],
        '7.3' => ['gte' => '1.0.1', 'lt' => '3.0'],
        '7.4' => ['gte' => '1.0.1', 'lt' => '3.0'],
        '8.0' => ['gte' => '1.0.1', 'lt' => '3.0'],
        '8.1' => ['gte' => '1.0.2', 'lt' => '4.0'],
        '8.2' => ['gte' => '1.0.2', 'lt' => '4.0'],
        '8.3' => ['gte' => '1.0.2', 'lt' => '4.0'],
        '8.4' => ['gte' => '1.0.2', 'lt' => '4.0'],
    ],
    'self-diagnosis.tls_versions' => [
        'TLS 1.0' => defined('CURL_SSLVERSION_TLSv1_0') ? CURL_SSLVERSION_TLSv1_0 : null,
        'TLS 1.1' => defined('CURL_SSLVERSION_TLSv1_1') ? CURL_SSLVERSION_TLSv1_1 : null,
        'TLS 1.2' => defined('CURL_SSLVERSION_TLSv1_2') ? CURL_SSLVERSION_TLSv1_2 : null,
        'TLS 1.3' => defined('CURL_SSLVERSION_TLSv1_3') ? CURL_SSLVERSION_TLSv1_3 : null,
    ],
    'self-diagnosis.result_logo' => 'ICAgICAgICA4ODg4ODg4ODg4ODg4ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICA4ODg4ODg4ODg4ODg4ODg4ODg4ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgODg4ODg4ODg4ODg4ODg4ODg4ODg4ODggICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICA4ODg4ODg4ODg4ODg4ODg4ODg4ODg4ODg4ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KIDg4ODg4ODg4OCAgICAgICAgIDg4ODg4ODg4OCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KODg4ODg4ODggICAgICAgICAgICAgODg4ODg4ODggICAgICAgICAgICAgICAgICAgKysrICAgICAgICAgICAgICAgKysrKyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICsrKysgICAgICAgICAgICArKysrKyAgICAgICAgICAgICAgKysrICAgICAgICArKysrICAgICAgIA0KODg4ODg4OCAgICAgICAgICAgICAgIDg4ODg4ODggICAgICAgICAgKysrKysrKysrKysrKysrKyAgICAgICArKysrKysrKysrKysrKysrICArKysrKysgICAgICArKysrKysgKysrKysrKysrKysrICAgICsrKysrKysrKysrKysgICAgICArKysrKysrICAgKysrKysrKysrKysrKysrKw0KODg4ODg4OCAgICAgICAgICAgICAgIDg4ODg4ODg4ICAgICAgICAgKysrKysrKysrKysrKysrKysrICAgICsrKysrKysrKysrKysrKysrICAgKysrKysgICAgICsrKysrKyArKysrKysrKysrKysrICAgKysrKysrKysrKysrKysrICAgKysrKysrKysrICArKysrKysrKysrKysrKysrKw0KODg4ODg4OCAgICAgICAgICAgICAgICsrKysrKysgICAgICAgICAgKysrKysrKyAgICAgKysrKysrKyAgKysrKysrICAgICArKysrKysrICAgKysrKysrICAgICsrKysrICArKysrKysgICAgKyAgICArKysrKysgICAgICsrKysrKyAgKysrKysrICAgICsrKysrKysgICAgICsrKysrKw0KODg4ODg4OCAgICAgICAgICAgICAgICsrKysrKysgICAgICAgICAgKysrKysrICAgICAgICsrKysrKyAgKysrKysgICAgICAgKysrKysrICAgICsrKysrKyAgKysrKysgICAgKysrKysrKysrICAgICsrKysrKysrKysrKysrKysrKyArKysrKysgICAgICsrKysrICAgICAgICArKysrKw0KODg4ODg4OCAgICAgICAgICAgICArKysrKysrKysgICAgICAgICAgKysrKysrICAgICAgICArKysrKyArKysrKysgICAgICAgICsrKysrICAgICArKysrKyArKysrKysgICAgICArKysrKysrKysrICsrKysrKysrKysrKysrKysrKyArKysrKysgICAgICsrKysrICAgICAgICArKysrKw0KODg4ODg4OCAgICAgICAgICAgKysrKysrKysrKyAgICAgICAgICAgKysrKysrICAgICAgICsrKysrKyAgKysrKysgICAgICAgKysrKysrICAgICAgKysrKysrKysrKyAgICAgICAgICAgKysrKysrKysrKysrKyAgICAgICAgICAgICArKysrKysgICAgICsrKysrKyAgICAgICArKysrKw0KODg4ODg4OCAgKysrKysrKysrKysrKysrKysgICAgICAgICAgICAgKysrKysrKysgICArKysrKysrICAgKysrKysrKysgICsrKysrKysrICAgICAgICsrKysrKysrICAgICArKysrKyAgICsrKysrKyArKysrKysrICAgICsrKysgICArKysrKysgICAgICArKysrKysrKyArKysrKysrKw0KODg4ODg4LSsrKysrKysrKysrKysrKysrKyAgICAgICAgICAgICAgKysrKysrKysrKysrKysrKysgICAgICsrKysrKysrKysrKysrKysrICAgICAgICsrKysrKysgICAgICsrKysrKysrKysrKysrICAgICsrKysrKysrKysrKysrICArKysrKysgICAgICAgKysrKysrKysrKysrKysrKw0KODg4OC0rKysrKysrKysrKysrKysrKysgICAgICAgICAgICAgICAgKysrKysrKysrKysrKysrICAgICAgICAgKysrKysrKysrKysrKysrICAgICAgICArKysrKyAgICAgICAgICsrKysrKysrKyAgICAgICAgKysrKysrKysrKyAgICArKysrKysgICAgICAgICArKysrKysrKysgKysrKw0KODg9KysrKysrKysrKysrKysrKyAgICAgICAgICAgICAgICAgICAgKysrKysgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICsrKysrKysrICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KOC0rKysrKysrKyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKysrKysgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICsrKysrKysgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KOCsrKysrKysgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKysrKysgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICsrKysrICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KKysrKysrKyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KKysrKysrKyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA==',
];
