<?php

namespace Paysera\Service;

use Paysera\Entity\CheckoutData;
use Paysera\Entity\PluginSettings;

class WebToPayRequestDataBuilder
{
    /**
     * @var string|null
     */
    private $language;

    /**
     * @var string|null
     */
    private $payment;

    /**
     * @var string|null
     */
    private $paymentCountry;

    /**
     * @param PluginSettings $pluginSettings
     * @param CheckoutDataManager $checkoutData
     * @param string $callbackUrl
     * @return array
     */
    public function buildWebToPayRequest(
        PluginSettings $pluginSettings,
        CheckoutData $checkoutData,
        $callbackUrl
    ) {
        return [
            'projectid' => $pluginSettings->getProjectId(),
            'sign_password' => $pluginSettings->getProjectPassword(),
            'accepturl' => $checkoutData->getReturnUrl(),
            'cancelurl' => $checkoutData->getReturnUrl(),
            'callbackurl' => $callbackUrl,
            'orderid' => $checkoutData->getInvoiceId(),
            'lang' => $this->language,
            'amount' => (int) number_format($checkoutData->getAmount(), 2, '', ''),
            'currency' => $checkoutData->getCurrency(),
            'payment' => $this->payment,
            'country' => $this->paymentCountry,
            'p_firstname' => $checkoutData->getPayerFirstName(),
            'p_lastname' => $checkoutData->getPayerLastName(),
            'p_email' => $checkoutData->getPayerEmail(),
            'p_street' => $checkoutData->getPayerState(),
            'p_city' => $checkoutData->getPayerCity(),
            'p_state' => $checkoutData->getPayerState(),
            'p_countrycode' => $checkoutData->getPayerCountryCode(),
            'test' => $pluginSettings->isTestModeEnabled() ? 1 : 0,
            'buyer_consent' => $pluginSettings->isBuyerConsentEnabled() ? 1 : 0,
        ];
    }

    /**
     * @param string $language
     * @return self
     */
    public function setLanguage($language)
    {
        $this->language = $language;

        return $this;
    }

    /**
     * @param string $payment
     * @return self
     */
    public function setPayment($payment)
    {
        $this->payment = $payment;

        return $this;
    }

    /**
     * @param string $paymentCountry
     * @return self
     */
    public function setPaymentCountry($paymentCountry)
    {
        $this->paymentCountry = $paymentCountry;

        return $this;
    }

}
