<?php
if(!function_exists("gracefulCoreRequiredFileInclude")) {
    require_once __DIR__ . '/../../../init.php';
}

require __DIR__ . '/libs/WebToPay.php';

class PayseraAutoloader
{
    const CLASSES_PREFIX = 'Paysera\\';

    public static function initPsr4()
    {
        spl_autoload_register([PayseraAutoloader::class, 'autoLoader']);
    }

    /**
     * @param string $class
     */
    public static function autoLoader($class)
    {
        $len = strlen(self::CLASSES_PREFIX);
        if (strncmp(self::CLASSES_PREFIX, $class, $len) !== 0) {
            return;
        }

        $relativeClass = substr($class, $len);
        $file =  __DIR__ . '/classes/' . str_replace('\\', '/', $relativeClass) . '.php';

        if (file_exists($file)) {
            require $file;
        }
    }
}
