<div class="paysera-hide" id="paysera-payment-choice">
    <div class="sub-heading">
        <span>Paysera</span>
    </div>
    {if $description !== null}
        <p class="paysera-description">{$description}</p>
    {/if}
    <div class="row">
        <div class="col-sm-12">
            <label for="paysera_checkout_country">{lang key='orderForm.country'}</label>
            <select id="paysera_checkout_country" name="paysera_country" class="field">
                {foreach $paymentMethodList->getCountries() as $country}
                    {if !empty($enabledCountries)}
                        {if in_array($country->getCode(), $enabledCountries)}
                            <option value="{$country->getCode()}" {if $activeCountry === $country->getCode()}selected{/if}>
                                {$country->getTitle()}
                            </option>
                        {/if}
                    {else}
                        <option value="{$country->getCode()}" {if $activeCountry === $country->getCode()}selected{/if}>
                            {$country->getTitle()}
                        </option>
                    {/if}
                {/foreach}
            </select>
            {if $gridViewEnabled}
                {foreach $paymentMethodList->getCountries() as $country}
                    <div class="paysera-payment-container {if $activeCountry !== $country->getCode()}paysera-hide{/if}" data-paysera-country="{$country->getCode()}">
                        {foreach $country->getGroups() as $group}
                            <p>{$group->getTitle()}</p>
                            <div class="row">
                                {foreach $group->getPaymentMethods() as $method}
                                    <div class="col-sm-4 form-check paysera-grid-view align-self-end">
                                        <div class="paysera-grid-selection">
                                            <input type="radio" id="paysera{$country->getCode()}{$method->getKey()}" name="paysera_payment" value="{$method->getKey()}" class="form-check-input" >
                                            <label for="paysera{$country->getCode()}{$method->getKey()}">
                                                {$method->getTitle()}
                                                {if $method->getLogoUrl()}
                                                    <img class="paysera-payment-logo" src="{$method->getLogoUrl()}" alt=""/>
                                                {/if}
                                            </label>
                                        </div>
                                    </div>
                                {/foreach}
                            </div>
                        {/foreach}
                    </div>
                {/foreach}
            {else}
                {foreach $paymentMethodList->getCountries() as $country}
                    <div class="paysera-payment-container {if $activeCountry !== $country->getCode()}paysera-hide{/if}" data-paysera-country="{$country->getCode()}">
                        {foreach $country->getGroups() as $group}
                            <p>{$group->getTitle()}</p>
                            <div class="row">
                                {foreach $group->getPaymentMethods() as $method}
                                    <div class="col-sm-12 form-check paysera-line-view">
                                        <input type="radio" id="paysera{$country->getCode()}{$method->getKey()}" name="paysera_payment" value="{$method->getKey()}" class="form-check-input" >
                                        <label for="paysera{$country->getCode()}{$method->getKey()}">
                                            {$method->getTitle()}
                                            {if $method->getLogoUrl()}
                                                <img class="paysera-payment-logo" src="{$method->getLogoUrl()}" alt=""/>
                                            {/if}
                                        </label>
                                    </div>
                                {/foreach}
                            </div>
                        {/foreach}
                    </div>
                {/foreach}
            {/if}
        </div>
    </div>
    {if $buyerConsentEnabled}
        <p class="paysera-buyer-consent">
            Please be informed that the account information and payment initiation services will be provided to you by
            Paysera in accordance with these <a href="https://www.paysera.lt/v2/en-LT/legal/pis-rules-2020" target="_blank" rel="noopener noreferrer">Rules</a>.
            By proceeding with this payment, you agree to receive this service and the service terms and conditions.
        </p>
    {/if}
</div>
