<?php

namespace Paysera\Service;

use Paysera\Normalizer\CheckoutDataNormalizer;
use Paysera\Validator\CheckoutDataValidator;
use Paysera\Exception\CheckoutDataValidatorException;
use Paysera\Entity\CheckoutData;

class CheckoutDataManager
{
    private $checkoutDataValidator;
    private $checkoutDataNormalizer;

    public function __construct()
    {
        $this->checkoutDataValidator = new CheckoutDataValidator();
        $this->checkoutDataNormalizer = new CheckoutDataNormalizer();
    }

    /**
     * @param array $checkoutDataMap
     * @return CheckoutData
     * @throws CheckoutDataValidatorException
     */
    public function validateAndGenerateCheckoutData(array $checkoutDataMap)
    {
        $this->checkoutDataValidator->validateCheckoutData($checkoutDataMap);

        return $this->checkoutDataNormalizer->mapToEntity($checkoutDataMap);
    }
}
