jQuery(document).ready(function() {
    const PAYMENT_GATEWAY_CONTAINER_ID = 'paymentGatewaysContainer';
    const CHECKOUT_COUNTRY_INPUT_ID = 'inputCountry';

    function doesNecessaryDataExists() {
        return (typeof PayseraCheckoutAmount !== 'undefined')
            && PayseraCheckoutAmount !== null
            && (typeof PayseraCheckoutCurrency !== 'undefined')
            && PayseraCheckoutCurrency !== null
            && jQuery('#' + CHECKOUT_COUNTRY_INPUT_ID).length > 0
        ;
    }

    if (doesNecessaryDataExists()) {
        jQuery.ajax({
            url: '/modules/gateways/paysera/ajax/PaymentList.php',
            type: 'POST',
            data: {
                paysera_amount: PayseraCheckoutAmount,
                paysera_currency: PayseraCheckoutCurrency,
                paysera_country: jQuery('#inputCountry').val(),
            }
        }).success(function (result) {
            jQuery('#' + PAYMENT_GATEWAY_CONTAINER_ID).append(result);

            new SubscribeToEvents();
        });
    }

    class SubscribeToEvents
    {
        constructor() {
            this.init();
            this.paymentMethodChange();
            this.payseraPaymentTypeChange();
            this.payseraPaymentCountryChange();
        }

        init() {
            if (jQuery('input[name="paymentmethod"]:checked').val() === 'paysera') {
                jQuery('#paysera-payment-choice').show('fast');
            }
        }

        paymentMethodChange () {
            jQuery('input[name="paymentmethod"]').on('ifChecked change', function() {
                let payseraPaymentChoice = jQuery('#paysera-payment-choice');

                if (jQuery(this).val() === 'paysera') {
                    payseraPaymentChoice.show('slow');
                } else {
                    payseraPaymentChoice.hide('slow');
                }
            });
        }

        payseraPaymentTypeChange() {
            jQuery('input[name="paysera_payment"]').click(function () {
                jQuery('.paysera-grid-selected').removeClass('paysera-grid-selected');
                jQuery(this).parent('div[class="paysera-grid-selection"]').addClass('paysera-grid-selected');
            });
        }

        payseraPaymentCountryChange() {
            jQuery('#paysera_checkout_country').change(function () {
                jQuery('.paysera-payment-container').hide('fast');
                jQuery('#paysera-payment-choice').find('div[data-paysera-country="' + jQuery(this).val() + '"]').show('fast');
            });
        }
    }
});
