<?php

namespace Paysera\Validator;

class PaymentRedirectRequestValidator
{
    public function isRequestDataValid($payment, $paymentCountry)
    {
        if (!is_string($payment) || strlen($payment) > 20) {
            return false;
        }

        if (
            !is_string($paymentCountry)
            || strlen($paymentCountry) !== 2
            || !preg_match('/^[a-z_]{2}$/i', $paymentCountry)
        ) {
            return false;
        }

        return true;
    }
}
