<?php

namespace Paysera\Validator;

use Paysera\Exception\PaymentListRequestValidatorException;

class PaymentListRequestValidator
{
    /**
     * @param float $amount
     * @param string $currency
     * @param string $country
     * @throws PaymentListRequestValidatorException
     */
    public function validateRequestData($amount, $currency, $country)
    {
        if (
            !is_numeric($amount)
            || filter_var($amount, FILTER_VALIDATE_FLOAT) === false
            || $amount < 0
        ) {
            throw new PaymentListRequestValidatorException('Given amount is not float');
        }

        if (!is_string($currency) || !ctype_alpha($currency) || strlen($currency) !== 3) {
            throw new PaymentListRequestValidatorException('Given currency is not valid');
        }

        if (!is_string($country) || !ctype_alpha($country) || strlen($country) !== 2) {
            throw new PaymentListRequestValidatorException('Given country is not valid');
        }
    }
}
