<?php

namespace Paysera\Service;

use Paysera\Exception\CheckoutDataValidatorException;
use Paysera\Helper\RedirectFormHelper;
use Paysera\Provider\PluginSettingsProvider;
use SmartyException;
use WebToPayException;
use WebToPay;

class RedirectForm
{
    const PAYSERA_COUNTRY_INPUT_KEY = 'paysera_country';
    const PAYSERA_PAYMENT_INPUT_KEY = 'paysera_payment';

    const REDIRECT_FORM_TEMPLATE = 'redirectForm.tpl';

    private $checkoutDataManager;
    private $pluginSettings;
    private $payserSmarty;
    private $redirectFormHelper;

    public function __construct()
    {
        $this->checkoutDataManager = new CheckoutDataManager();
        $this->pluginSettings = (new PluginSettingsProvider())->getPluginSettings();
        $this->payserSmarty = (new PayseraSmarty())->buildSmarty();
        $this->redirectFormHelper = new RedirectFormHelper();
    }

    /**
     * @param array|null $whmcsLanguage
     * @param array $checkoutDataMap
     * @return string
     * @throws SmartyException|WebToPayException|CheckoutDataValidatorException
     */
    public function buildRedirectForm($whmcsLanguage, array $checkoutDataMap)
    {
        $checkoutData = $this->checkoutDataManager->validateAndGenerateCheckoutData($checkoutDataMap);

        $request = WebToPay::buildRequest(
            $this->redirectFormHelper->buildWebToPayMap($whmcsLanguage, $this->pluginSettings, $checkoutData)
        );

        $this->payserSmarty->assign('actionUrl', WebToPay::PAY_URL);
        $this->payserSmarty->assign('data', $request['data']);
        $this->payserSmarty->assign('sign', $request['sign']);

        return $this->payserSmarty->fetch(self::REDIRECT_FORM_TEMPLATE);
    }
}
