<?php

namespace Paysera\Service;

use WHMCS\Smarty as WHMCSSmarty;
use Smarty;

class PayseraSmarty
{
    /**
     * @var string
     */
    private $templateDir;

    public function __construct()
    {
        $this->templateDir = $this->generateTemplateDir();
    }

    /**
     * @return Smarty
     */
    public function buildSmarty()
    {
        return (new WHMCSSmarty())
            ->setTemplateDir($this->templateDir)
        ;
    }

    /**
     * @return string
     */
    private function generateTemplateDir()
    {
        return __DIR__ . '/../../templates';
    }
}
