<?php

namespace Paysera\Provider;

use Paysera\Entity\PluginSettings;
use Paysera\Normalizer\PluginSettingsNormalizer;
use WHMCS\Module\Gateway;

class PluginSettingsProvider
{
    private $pluginSettingsNormalizer;

    public function __construct()
    {
        $this->pluginSettingsNormalizer = new PluginSettingsNormalizer();
    }

    /**
     * @return PluginSettings
     */
    public function getPluginSettings()
    {
        return $this->pluginSettingsNormalizer->mapsToEntity($this->fetchPluginData());
    }

    /**
     * @return array
     */
    private function fetchPluginData()
    {
        $gateway = new Gateway();
        $gateway->load(PluginSettings::PLUGIN_NAME);

        return $gateway->loadSettings();
    }
}
