<?php

namespace Paysera\Normalizer;

use Paysera\Entity\PluginSettings;
use Paysera\Service\AdminForm;

class PluginSettingsNormalizer
{
    /**
     * @param string[] $settings
     * @return PluginSettings
     */
    public function mapsToEntity(array $settings)
    {
        $pluginSettings = new PluginSettings();

        if (isset($settings[AdminForm::SETTINGS_PROJECT_ID_KEY])) {
            $pluginSettings->setProjectId((int) $settings[AdminForm::SETTINGS_PROJECT_ID_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_PROJECT_PASSWORD_KEY])) {
            $pluginSettings->setProjectPassword($settings[AdminForm::SETTINGS_PROJECT_PASSWORD_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_TEST_MODE_KEY])) {
            $pluginSettings->setTestMode($settings[AdminForm::SETTINGS_TEST_MODE_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_DESCRIPTION_KEY])) {
            $pluginSettings->setDescription($settings[AdminForm::SETTINGS_DESCRIPTION_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_PAYMENT_LIST_KEY])) {
            $pluginSettings->setPaymentList($settings[AdminForm::SETTINGS_PAYMENT_LIST_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_ENABLED_COUNTRIES_KEY])) {
            $pluginSettings->setEnabledCountries($settings[AdminForm::SETTINGS_ENABLED_COUNTRIES_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_GRID_VIEW_KEY])) {
            $pluginSettings->setGridView($settings[AdminForm::SETTINGS_GRID_VIEW_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_BUYER_CONSENT_KEY])) {
            $pluginSettings->setBuyerConsent($settings[AdminForm::SETTINGS_BUYER_CONSENT_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_QUALITY_SIGN_KEY])) {
            $pluginSettings->setQualitySign($settings[AdminForm::SETTINGS_QUALITY_SIGN_KEY]);
        }

        if (isset($settings[AdminForm::SETTINGS_OWNERSHIP_CODE_KEY])) {
            $pluginSettings->setOwnershipCode($settings[AdminForm::SETTINGS_OWNERSHIP_CODE_KEY]);
        }

        return $pluginSettings;
    }
}
