<?php

namespace Paysera\Normalizer;

use WHMCS\View\Formatter\Price;
use Paysera\Entity\CheckoutData;

class CheckoutDataNormalizer
{
    /**
     * @param array $map
     * @return CheckoutData
     */
    public function mapToEntity(array $map)
    {
        $checkoutData = new CheckoutData();

        if (isset($map['rawtotal'])) {
            $checkoutData->setRawTotal((float) $map['rawtotal']);
        }

        if (isset($map['total']) && $map['total'] instanceof Price) {
            $checkoutData->setPriceTotal($map['total']);
        }

        if (isset($map['amount'])) {
            $checkoutData->setAmount((float) $map['amount']);
        }

        if (isset($map['currency'])) {
            $checkoutData->setCurrency($map['currency']);
        }

        if (isset($map['country'])) {
            $checkoutData->setBillingCountry($map['country']);
        }

        if (isset($map['invoiceid'])) {
            $checkoutData->setInvoiceId((int) $map['invoiceid']);
        }

        if (isset($map['returnurl'])) {
            $checkoutData->setReturnUrl($map['returnurl']);
        }

        if (isset($map['systemurl'])) {
            $checkoutData->setSystemUrl($map['systemurl']);
        }

        if (isset($map['clientdetails']['countrycode'])) {
            $checkoutData->setPayerCountryCode($map['clientdetails']['countrycode']);
        }

        if (isset($map['clientdetails']['firstname'])) {
            $checkoutData->setPayerFirstName($map['clientdetails']['firstname']);
        }

        if (isset($map['clientdetails']['lastname'])) {
            $checkoutData->setPayerLastName($map['clientdetails']['lastname']);
        }

        if (isset($map['clientdetails']['email'])) {
            $checkoutData->setPayerEmail($map['clientdetails']['email']);
        }

        if (isset($map['clientdetails']['address1'])) {
            $checkoutData->setPayerStreet($map['clientdetails']['address1']);
        }

        if (isset($map['clientdetails']['city'])) {
            $checkoutData->setPayerCity($map['clientdetails']['city']);
        }

        if (isset($map['clientdetails']['state'])) {
            $checkoutData->setPayerState($map['clientdetails']['state']);
        }

        if (isset($map['clientdetails']['postcode'])) {
            $checkoutData->setPayerPostCode($map['clientdetails']['postcode']);
        }

        return $checkoutData;
    }
}
