<?php

namespace Paysera\Hook;

use Paysera\Provider\PluginSettingsProvider;
use Paysera\Service\PayseraSmarty;
use SmartyException;

class OwnershipCodeHook
{
    const OWNERSHIP_CODE_TEMPLATE = 'ownershipCode.tpl';

    private $pluginSettings;
    private $smarty;

    public function __construct()
    {
        $this->pluginSettings = (new PluginSettingsProvider())->getPluginSettings();
        $this->smarty = (new PayseraSmarty())->buildSmarty();
    }

    /**
     * @return string
     * @throws SmartyException
     */
    public function buildOwnershipCodeResponse()
    {
        $this->smarty->assign('ownershipCode', $this->pluginSettings->getOwnershipCode());

        return $this->smarty->fetch(self::OWNERSHIP_CODE_TEMPLATE);
    }
}
