<?php

namespace Paysera\Helper;

use Paysera\Service\RedirectForm;
use Paysera\Validator\PaymentRedirectRequestValidator;
use WHMCS\Session;
use App;

class StorageHelper
{
    private $paymentRedirectRequestValidator;

    /**
     * @var string|null
     */
    private $payment;

    /**
     * @var string|null
     */
    private $paymentCountry;

    public function __construct()
    {
        $this->paymentRedirectRequestValidator = new PaymentRedirectRequestValidator();

        $this->storePayseraData();
    }
    /**
     * @return string
     */
    public function getPayseraPayment()
    {
        return $this->payment !== null ?
            $this->payment
            : Session::getAndDelete(RedirectForm::PAYSERA_PAYMENT_INPUT_KEY)
        ;
    }

    /**
     * @return string
     */
    public function getPayseraPaymentCountry()
    {
        return $this->paymentCountry !== null ?
            $this->paymentCountry
            : Session::getAndDelete(RedirectForm::PAYSERA_COUNTRY_INPUT_KEY)
        ;
    }

    private function storePayseraData()
    {
        $payment = App::getFromRequest(RedirectForm::PAYSERA_PAYMENT_INPUT_KEY);
        $paymentCountry = App::getFromRequest(RedirectForm::PAYSERA_COUNTRY_INPUT_KEY);

        if ($this->paymentRedirectRequestValidator->isRequestDataValid($payment, $paymentCountry)) {
            Session::set(RedirectForm::PAYSERA_PAYMENT_INPUT_KEY, $payment);
            Session::set(RedirectForm::PAYSERA_COUNTRY_INPUT_KEY, $paymentCountry);

            $this->payment = $payment;
            $this->paymentCountry = $paymentCountry;
        }
    }
}
