<?php

namespace Paysera\Helper;

use Paysera\Entity\CheckoutData;
use Paysera\Entity\PluginSettings;
use Paysera\Service\WebToPayRequestDataBuilder;

class RedirectFormHelper
{
    private $languageHelper;
    private $storageHelper;

    public function __construct()
    {
        $this->languageHelper = new LanguageHelper();
        $this->storageHelper = new StorageHelper();
    }

    /**
     * @param array|null $whmcsLanguage
     * @param PluginSettings $pluginSettings
     * @param CheckoutData $checkoutData
     * @return array
     */
    public function buildWebToPayMap($whmcsLanguage, PluginSettings $pluginSettings, CheckoutData $checkoutData)
    {
        $webToPayRequestDataBuilder = new WebToPayRequestDataBuilder();

        $language = $this->languageHelper->resolveLanguageToISO6392(
            $this->languageHelper->getClientLanguage($whmcsLanguage)
        );

        $payseraPayment = $this->storageHelper->getPayseraPayment();

        $payseraPaymentCountry = $this->storageHelper->getPayseraPaymentCountry();

        if ($language !== null) {
            $webToPayRequestDataBuilder->setLanguage($language);
        }

        if (!empty($payseraPayment)) {
            $webToPayRequestDataBuilder->setPayment($payseraPayment);
        }

        if (!empty($payseraPaymentCountry)) {
            $webToPayRequestDataBuilder->setPaymentCountry($payseraPaymentCountry);
        }

        return $webToPayRequestDataBuilder->buildWebToPayRequest(
            $pluginSettings,
            $checkoutData,
            $this->getCallbackUrl($checkoutData)
        );
    }

    /**
     * @param CheckoutData $checkoutData
     * @return string
     */
    private function getCallbackUrl(CheckoutData $checkoutData)
    {
        return $checkoutData->getSystemUrl() . 'modules/gateways/callback/paysera.php';
    }
}
