<?php

namespace Paysera\Helper;

use Paysera\Entity\PluginSettings;
use WebToPay;
use WebToPayException;
use WebToPay_PaymentMethodList;

class PaymentHelper
{
    const DEFAULT_CURRENCY = 'EUR';

    /**
     * @param PluginSettings $pluginSettings
     * @param string $currency
     * @param string $language
     * @param float $amount
     * @return WebToPay_PaymentMethodList
     * @throws WebToPayException
     */
    public function getPaymentMethodList(PluginSettings $pluginSettings, $language, $amount, $currency)
    {
        return WebToPay::getPaymentMethodList($pluginSettings->getProjectId(), $currency)
            ->setDefaultLanguage($language)
            ->filterForAmount($amount, $currency)
        ;
    }

    /**
     * @param int $projectId
     * @param string $currency
     * @param string $language
     * @return string[]
     */
    public function generateAvailableCountries($projectId, $currency = self::DEFAULT_CURRENCY, $language = 'en')
    {
        try {
            $paymentMethods = WebToPay::getPaymentMethodList($projectId, $currency)
                ->setDefaultLanguage($language)
                ->getCountries()
            ;
        } catch (WebToPayException $exception) {
            logActivity('[Paysera] Got an exception: ' . $exception);

            return [];
        }

        $availableCountries = [];

        foreach ($paymentMethods as $country) {
            $availableCountries[$country->getCode()] = $country->getTitle();
        }

        return $availableCountries;
    }

    /**
     * @param PluginSettings $pluginSettings
     * @param WebToPay_PaymentMethodList $paymentMethodList
     * @param string $billingCountry
     * @return string
     */
    public function getActiveCountry(
        PluginSettings $pluginSettings,
        WebToPay_PaymentMethodList $paymentMethodList,
        $billingCountry
    ) {
        if (!empty($pluginSettings->getEnabledCountries())) {
            if (!in_array($billingCountry, $pluginSettings->getEnabledCountries(), true)) {
                return $pluginSettings->getEnabledCountries()[0];
            }
        }

        foreach ($paymentMethodList->getCountries() as $country) {
            if ($country->getCode() === $billingCountry) {
                return $billingCountry;
            }
        }

        return 'other';
    }
}
