<?php

namespace Paysera\Helper;

class LanguageHelper
{
    /**
     * @param array|null $whmcsLanguage
     * @param string $fallbackLanguage
     * @return string
     */
    public function getClientLanguage($whmcsLanguage, $fallbackLanguage = 'en')
    {
        $resolvedLanguage = $this->resolveWhmcsLanguage($this->getClientLocale($whmcsLanguage));

        if ($resolvedLanguage === null) {
            return $fallbackLanguage;
        }

        return $resolvedLanguage;
    }

    /**
     * @param string $language
     * @return string|null
     */
    public function resolveLanguageToISO6392($language)
    {
        switch ($language) {
            case 'en': {
                return 'ENG';
            }
            case 'lt': {
                return 'LIT';
            }
            case 'lv': {
                return 'LAV';
            }
            case 'es': {
                return 'EST';
            }
            case 'ru': {
                return 'RUS';
            }
            case 'de': {
                return 'GER';
            }
            case 'pl': {
                return 'POL';
            }
            default: {
                return null;
            }
        }
    }

    /**
     * @param array|null $lang
     * @return string|null
     */
    private function getClientLocale($lang)
    {
        return !isset($lang['locale']) ?: $lang['locale'];
    }

    /**
     * @param string $whmcsLanguage
     * @return string
     */
    private function resolveWhmcsLanguage($whmcsLanguage)
    {
        switch ($whmcsLanguage) {
            case 'en_GB': {
                return 'en';
            }
            case 'lt_LT': {
                return 'lt';
            }
            case 'lv_LV': {
                return 'lav';
            }
            case 'ee_EE': {
                return 'ee';
            }
            case 'ru_RU': {
                return 'ru';
            }
            case 'de_DE': {
                return 'de';
            }
            case 'pl_PL': {
                return 'pl';
            }
            default: {
                return substr($whmcsLanguage, 0, 2);
            }
        }
    }
}
