<?php
if (!defined('WHMCS')) {
    exit('This file cannot be accessed directly');
}

if (!class_exists('PayseraAutoloader')) {
    require 'paysera/PayseraAutoloader.php';

    PayseraAutoloader::initPsr4();
}

use Paysera\Service\AdminForm;
use Paysera\Provider\PluginSettingsProvider;
use Paysera\Normalizer\CheckoutDataNormalizer;
use Paysera\Hook\PaymentListJavascriptHook;
use Paysera\Service\RedirectForm;
use Paysera\Helper\PaymentHelper;
use Paysera\Helper\LanguageHelper;
use Paysera\Exception\AdminFormPostSaveException;
use Paysera\Exception\CheckoutDataValidatorException;

/**
 * @return array
 */
function paysera_config()
{
    global $_LANG;

    $paymentHelper = new PaymentHelper();
    $pluginSettings = (new PluginSettingsProvider())->getPluginSettings();
    $languageHelper = new LanguageHelper();

    $availableCountries = $paymentHelper->generateAvailableCountries(
        $pluginSettings->getProjectId(),
        PaymentHelper::DEFAULT_CURRENCY,
        $languageHelper->getClientLanguage($_LANG)
    );

    return (new AdminForm())->buildForm($availableCountries);
}

/**
 * @param array $postData
 * @throws AdminFormPostSaveException
 */
function paysera_config_post_save(array $postData)
{
    if (filter_var($postData[AdminForm::SETTINGS_PROJECT_ID_KEY], FILTER_VALIDATE_INT) === false) {
        throw new AdminFormPostSaveException('Project ID must be integer');
    }
}

/**
 * @param array $checkoutDataMap
 * @return string
 * @throws SmartyException|WebToPayException|CheckoutDataValidatorException
 */
function paysera_link(array $checkoutDataMap)
{
    global $_LANG;

    return (new RedirectForm())->buildRedirectForm($_LANG, $checkoutDataMap);
}

/**
 * @param array $checkoutDataMap
 * @return string|void
 */
function paysera_credit_card_input(array $checkoutDataMap)
{
    try {
        $checkoutData = (new CheckoutDataNormalizer())->mapToEntity($checkoutDataMap);

        return (new PaymentListJavascriptHook())->builPaymentListJavascriptResponse($checkoutData);
    } catch (Exception $exception) {
        logActivity('[Paysera] Got an exception: ' . $exception);
    }
}
