<?php
require '../../../init.php';
require '../../../includes/functions.php';
require '../../../includes/gatewayfunctions.php';
require '../../../includes/invoicefunctions.php';
require '../lib/WebToPay.php';

use WHMCS\Database\Capsule;

$gatewayModule = 'paysera';

$GATEWAY = getGatewayVariables($gatewayModule);

if (!$GATEWAY['type']) {
    echo 'Module Not Activated';

    exit;
}

try {
    $response = WebToPay::validateAndParseData($_REQUEST, $GATEWAY['projectID'], $GATEWAY['projectPass']);

    $orderId = intval($response['orderid']);

    $invoiceId = checkCbInvoiceID($orderId, $GATEWAY["paymentmethod"]);

    $requestId = $response['requestid'];

    checkCbTransID($orderId);

    if (isset($_REQUEST['accepturl'])) {
        if (!empty($gateway['systemurl'])) {
            $systemUrl = $gateway['systemurl'];
        } else {
            $systemUrl = '';
        }

        header('Location: ' . $systemUrl . '/viewinvoice.php?id=' . $invoiceId);

        exit;
    }

    if ($response['status'] == 1) {
        $realOrderAmount = getOrderAmount($orderId);

        if (isset($GATEWAY['convertto'])) {
            $rate = getOrderRate($response);

            $convertedOrderAmount = $realOrderAmount * $rate;

            $convertedOrderAmountInCents = round($convertedOrderAmount * 100);
        }

        $orderData = [
            'amount' => (string) $convertedOrderAmountInCents,
            'currency' => $response['currency'],
            'response' => $response,
        ];

        $isPaymentCorrect = checkPayment($orderData, $response);

        if ($isPaymentCorrect) {
            addInvoicePayment($invoiceId, $requestId, '', '', $gatewayModule);

            _log(
                '[Success] Paid',
                $orderData
            );

            echo 'OK';
        }
    }
} catch (Exception $e) {
    _log(
        '[Error] Exception',
        [
            'exception' => get_class($e) . ": " . $e->getMessage(),
            'request' => $_REQUEST,
        ]
    );

    exit;
}

function getOrderAmount($orderId)
{
    $orderAmount = Capsule::table('tblinvoices')
        ->where('id', $orderId)
        ->select('total')
        ->get()
    ;

    $realOrderAmount = $orderAmount[0]->total;

    return $realOrderAmount;
}

function getOrderRate($data)
{
    $currencyCode = $data['currency'];

    $rateResult = Capsule::table('tblcurrencies')
        ->where('code', $currencyCode)
        ->select('rate')
        ->get()
    ;

    $rate = $rateResult[0]->rate;

    return $rate;
}

function checkPayment($orderMoney, $response)
{
    $orderAmount   = $orderMoney['amount'];
    $orderCurrency = $orderMoney['currency'];

    if ($response['amount'] !== $orderAmount
        || $response['currency'] !== $orderCurrency) {
        $checkConvert = array_key_exists('payamount', $response);
        if (!$checkConvert) {
            exit(sprintf(
                'Wrong pay amount: ' . $response['amount'] / 100 . $response['currency']
                . ', expected: ' . $orderAmount / 100 . $orderCurrency
            ));
        } elseif ($response['payamount'] !== $orderAmount
            || $response['paycurrency'] !== $orderCurrency) {
            exit(sprintf(
                'Wrong pay amount: ' . $response['payamount'] / 100 . $response['paycurrency']
                . ', expected: ' . $orderAmount / 100 . $orderCurrency
            ));
        }
    }

    return true;
}

function _log($msg, $data = null)
{
    global $GATEWAY;
    logTransaction($GATEWAY['name'], var_export($data, true), $msg);
}
