<?php

include("../../../dbconnect.php");
include("../../../includes/functions.php");
include("../../../includes/gatewayfunctions.php");
include("../../../includes/invoicefunctions.php");

require_once('../lib/WebToPay.php');

$gatewayModule = "paysera";

$GATEWAY = getGatewayVariables($gatewayModule);

try {
    $response = WebToPay::validateAndParseData($_REQUEST, $GATEWAY['projectID'], $GATEWAY['projectPass']);

    $orderId   = intval(mysql_real_escape_string($response['orderid']));
    $invoiceId = checkCbInvoiceID($orderId, $GATEWAY["paymentmethod"]);

    checkCbTransID($orderId);

    if (isset($_REQUEST['accepturl'])) {
        logTransaction($GATEWAY["name"], $_REQUEST, "Successful");

        $systemUrl = ($CONFIG['SystemSSLURL'] ? $CONFIG['SystemSSLURL'] : $CONFIG['SystemURL']);

        $redirectPage = $systemUrl . ("/viewinvoice.php?id=" . $invoiceId . "&paymentsuccess=true");

        header("Location: $redirectPage");

        exit;
    }

    if ($response['status'] == 1) {
        $orderTotal = mysql_query("SELECT total FROM tblinvoices WHERE id = " . $orderId);
        $orderTotalAmount = mysql_result($orderTotal, 0);

        if (isset($GATEWAY['convertto'])) {
            $orderCurrencyRate = mysql_query(
                "SELECT rate FROM tblcurrencies WHERE code = '" . $response['currency'] . "'"
            );

            $currencyRate = mysql_result($orderCurrencyRate, 0);

            $realOrderAmount = $orderTotalAmount * $currencyRate;

            $realOrderAmountInCents = round($realOrderAmount * 100);
        }

        $orderData = array(
            'amount' => (string) $realOrderAmountInCents,
            'currency' => $response['currency'],
        );

        $isPaymentCorrect = checkPayment($orderData ,$response);

        if ($isPaymentCorrect) {
            addInvoicePayment($orderId, $response['requestid'], '', '', $GATEWAY["paymentmethod"]);

            logTransaction($GATEWAY["paymentmethod"], $_POST, "Successful");

            echo 'OK';
        }
    }

} catch (Exception $e) {
    logTransaction($GATEWAY["name"], $_REQUEST, "[CALLBACK]Unsuccessful");

    $exceptionMessage = get_class($e) . ': ' . $e->getMessage();

    exit($exceptionMessage);
}

function checkPayment($orderMoney, $response)
{
    $orderAmount   = $orderMoney['amount'];
    $orderCurrency = $orderMoney['currency'];

    if ($response['amount'] !== $orderAmount
        || $response['currency'] !== $orderCurrency) {
        $checkConvert = array_key_exists('payamount', $response);
        if (!$checkConvert) {
            exit(sprintf(
                'Wrong pay amount: ' . $response['amount'] / 100 . $response['currency']
                . ', expected: ' . $orderAmount / 100 . $orderCurrency
            ));
        } elseif ($response['payamount'] !== $orderAmount
            || $response['paycurrency'] !== $orderCurrency) {
            exit(sprintf(
                'Wrong pay amount: ' . $response['payamount'] / 100 . $response['paycurrency']
                . ', expected: ' . $orderAmount / 100 . $orderCurrency
            ));
        }
    }

    return true;
}
