<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Validator;

use SwagPayseraCheckout\Entity\PaymentRequest;
use SwagPayseraCheckout\Exception\PaymentRequestValidationException;

class PaymentRequestValidator
{
    /**
     * @param array $data
     * @throws PaymentRequestValidationException
     */
    public function validatePaymentRequest(array $data): void
    {
        if (!isset($data[PaymentRequest::PAYMENT_HASH_KEY])) {
            throw new PaymentRequestValidationException('Missing payment hash missing in payment request');
        }

        if (!isset($data[PaymentRequest::UNIQUE_PAYMENT_ID])) {
            throw new PaymentRequestValidationException('Missing unique payment id missing in payment request');
        }
    }
}
