<?php

declare(strict_types=1);

namespace SwagPayseraCheckout;

use Shopware\Components\Plugin;
use Shopware\Components\Plugin\Context\ActivateContext;
use Shopware\Components\Plugin\Context\DeactivateContext;
use Shopware\Components\Plugin\Context\InstallContext;
use Shopware\Components\Plugin\Context\UninstallContext;
use Shopware\Components\Plugin\PaymentInstaller;
use Shopware\Models\Payment\Payment;

class SwagPayseraCheckout extends Plugin
{
    public const PLUGIN_NAME = 'SwagPayseraCheckout';

    /**
     * @param InstallContext $context
     */
    public function install(InstallContext $context)
    {
        /** @var PaymentInstaller $installer */
        $installer = $this->container->get('shopware.plugin_payment_installer');

        $options = [
            'name' => 'paysera_checkout',
            'description' => 'All popular payment methods | Paysera',
            'action' => 'PayseraPayment',
            'active' => 1,
            'position' => 0,
            'additionalDescription' =>
                'Paysera payment gateway for collecting funds'
                . '<img src="custom/plugins/SwagPayseraCheckout/paysera-logo.png" alt="">',
        ];

        $installer->createOrUpdate($context->getPlugin(), $options);
    }

    public function uninstall(UninstallContext $context)
    {
        $this->setActiveFlag($context, false);
    }

    public function deactivate(DeactivateContext $context)
    {
        $this->setActiveFlag($context, false);
    }

    public function activate(ActivateContext $context)
    {
        $this->setActiveFlag($context, true);
    }

    private function setActiveFlag(InstallContext $installContext, bool $active): void
    {
        /** @var Payment[] $payments */
        $payments = $installContext->getPlugin()->getPayments();

        $em = $this->container->get('models');

        foreach ($payments as $payment) {
            $payment->setActive($active);
        }

        $em->flush();
    }
}
