<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Service;

use SwagPayseraCheckout\Normalizer\UserNormalizer;
use SwagPayseraCheckout\SwagPayseraCheckout;

class PaymentHashHelper
{
    private $userNormalizer;

    public function __construct(UserNormalizer $userNormalizer)
    {
        $this->userNormalizer = $userNormalizer;
    }

    public function getPaymentHash(array $userData, float $amount): string
    {
        $user = $this->userNormalizer->mapToUser($userData);

        return sha1(SwagPayseraCheckout::PLUGIN_NAME . $user->getSession() . $user->getEmail() . $amount);
    }
}
