<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Provider;

use Shopware\Components\Plugin\CachedConfigReader;
use SwagPayseraCheckout\Entity\PluginSettings;
use SwagPayseraCheckout\Exception\ProjectSettingsException;
use SwagPayseraCheckout\Normalizer\PluginSettingsNormalizer;
use SwagPayseraCheckout\SwagPayseraCheckout;
use SwagPayseraCheckout\Validator\ProjectSettingsValidator;

class PluginSettingsProvider
{
    private $shopProvider;
    private $cachedConfigReader;
    private $pluginSettingsNormalizer;
    private $projectSettingsValidator;

    public function __construct(
        ShopProvider $shopProvider,
        CachedConfigReader $cachedConfigReader,
        PluginSettingsNormalizer $pluginSettingsNormalizer,
        ProjectSettingsValidator $projectSettingsValidator
    ) {
        $this->shopProvider = $shopProvider;
        $this->cachedConfigReader = $cachedConfigReader;
        $this->pluginSettingsNormalizer = $pluginSettingsNormalizer;
        $this->projectSettingsValidator = $projectSettingsValidator;
    }

    /**
     * @param int|null $shopId
     * @return PluginSettings
     * @throws ProjectSettingsException
     */
    public function getProjectSettingsByShopId(?int $shopId): PluginSettings
    {
        $shop = null;

        if ($shopId !== null) {
            $shop = $this->shopProvider->getShopById($shopId);
        }

        $pluginConfig = $this->cachedConfigReader->getByPluginName(SwagPayseraCheckout::PLUGIN_NAME, $shop);

        $this->projectSettingsValidator->validateProjectSettings($pluginConfig);

        return $this->pluginSettingsNormalizer->mapToPluginSettings($pluginConfig);
    }
}
