<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Normalizer;

use SwagPayseraCheckout\Entity\User;

class UserNormalizer
{
    public function mapToUser(array $data): User
    {
        $user = (new User())
            ->setSession($data['additional']['user']['sessionID'])
        ;

        if (isset($data['billingaddress']['firstname']) && $data['billingaddress']['firstname'] !== null) {
            $user->setFirstName($data['billingaddress']['firstname']);
        }

        if (isset($data['billingaddress']['lastname']) && $data['billingaddress']['lastname'] !== null) {
            $user->setLastName($data['billingaddress']['lastname']);
        }

        if (isset($data['additional']['user']['email']) && $data['billingaddress']['lastname'] !== null) {
            $user->setEmail($data['additional']['user']['email']);
        }

        if (isset($data['billingaddress']['street']) && $data['billingaddress']['street'] !== null) {
            $user->setStreet($data['billingaddress']['street']);
        }

        if (isset($data['billingaddress']['city']) && $data['billingaddress']['city'] !== null) {
            $user->setCity($data['billingaddress']['city']);
        }

        if (isset($data['billingaddress']['state']) && $data['billingaddress']['state'] !== null) {
            $user->setState($data['billingaddress']['state']);
        }

        if (isset($data['billingaddress']['zipcode']) && $data['billingaddress']['zipcode'] !== null) {
            $user->setZipCode($data['billingaddress']['zipcode']);
        }

        if (
            isset($data['additional']['country']['countryiso'])
            && $data['additional']['country']['countryiso'] !== null
        ) {
            $user->setZipCode($data['billingaddress']['zipcode']);
        }

        if (
            isset($data['additional']['country']['countryiso'])
            && $data['additional']['country']['countryiso'] !== null
        ) {
            $user->setIsoCountryCode($data['additional']['country']['countryiso']);
        }

        return $user;
    }
}
