<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Normalizer;

use SwagPayseraCheckout\Entity\PluginSettings;

class PluginSettingsNormalizer
{
    public function mapToPluginSettings(array $data): PluginSettings
    {
        $pluginSettings = (new PluginSettings())
            ->setProjectId((int) $data['project_id'])
            ->setProjectSign($data['sign_password'])
        ;

        if (isset($data['test_enabled']) && is_bool($data['test_enabled'])) {
            $pluginSettings->setTest($data['test_enabled']);
        }

        return $pluginSettings;
    }
}
