<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Normalizer;

use SwagPayseraCheckout\Entity\PaymentRequest;

class PaymentRequestNormalizer
{
    public function mapToWebToPayRequest(array $data): PaymentRequest
    {
        $paymentRequest = (new PaymentRequest())
            ->setOrderId($data['orderid'])
            ->setAmount((int) $data['amount'])
            ->setCurrency($data['currency'])
            ->setPaymentHash($data[PaymentRequest::PAYMENT_HASH_KEY])
            ->setUniquePaymentId($data[PaymentRequest::UNIQUE_PAYMENT_ID])
            ->setStatus((int) $data['status'])
            ->setType($data['type'])
        ;

        if (isset($data['payamount'])) {
            $paymentRequest->setPayAmount((int) $data['payamount']);
        }

        if (isset($data['paycurrency'])) {
            $paymentRequest->setPayCurrency($data['paycurrency']);
        }

        return $paymentRequest;
    }
}
