<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Validator;

use SwagPayseraCheckout\Exception\ProjectSettingsException;

class ProjectSettingsValidator
{
    /**
     * @param array $data
     * @throws ProjectSettingsException
     */
    public function validateProjectSettings(array $data): void
    {
        if (!isset($data['project_id'])) {
            throw new ProjectSettingsException('Missing paysera project_id parameter');
        }

        if (!isset($data['sign_password'])) {
            throw new ProjectSettingsException('Missing paysera sign_password parameter');
        }
    }
}
