<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Service;

use SwagPayseraCheckout\Entity\PaymentRequest;
use SwagPayseraCheckout\Entity\PluginSettings;
use SwagPayseraCheckout\Entity\User;

class PaymentRequestMapper
{
    private $amountFormatter;

    public function __construct(AmountFormatter $amountFormatter)
    {
        $this->amountFormatter = $amountFormatter;
    }

    public function mapRequestData(
        User $user,
        PluginSettings $pluginSettings,
        string $orderNumber,
        string $acceptUrl,
        string $cancelUrl,
        string $callbackUrl,
        float $amount,
        string $currency,
        string $paymentHash,
        string $uniquePaymentId,
        ?int $shopId
    ): array {
        $map = [
            'projectid' => $pluginSettings->getProjectId(),
            'sign_password' => $pluginSettings->getProjectSign(),
            'orderid' => $orderNumber,
            'accepturl' => $acceptUrl,
            'cancelurl' => $cancelUrl,
            'callbackurl' => $callbackUrl,
            'amount' => $this->amountFormatter->formatAmountInCents($amount),
            'currency' => $currency,
            'test' => (int) $pluginSettings->isTestEnabled(),
            PaymentRequest::PAYMENT_HASH_KEY => $paymentHash,
            PaymentRequest::SHOP_ID_KEY => $shopId,
            PaymentRequest::UNIQUE_PAYMENT_ID => $uniquePaymentId,
        ];

        if ($user->getFirstName() !== null) {
            $map['p_firstname'] = $user->getFirstName();
        }

        if ($user->getLastName() !== null) {
            $map['p_lastname'] = $user->getLastName();
        }

        if ($user->getEmail() !== null) {
            $map['p_email'] = $user->getEmail();
        }

        if ($user->getStreet() !== null) {
            $map['p_street'] = $user->getStreet();
        }

        if ($user->getCity() !== null) {
            $map['p_city'] = $user->getCity();
        }

        if ($user->getZipCode() !== null) {
            $map['p_zip'] = $user->getZipCode();
        }

        if ($user->getState() !== null) {
            $map['p_state'] = $user->getState();
        }

        if ($user->getIsoCountryCode() !== null) {
            $map['country'] = $user->getIsoCountryCode();
            $map['p_countrycode'] = $user->getIsoCountryCode();
        }

        return $map;
    }
}
