<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Service;

use SwagPayseraCheckout\Exception\ProjectSettingsException;
use SwagPayseraCheckout\Normalizer\UserNormalizer;
use SwagPayseraCheckout\Provider\PluginSettingsProvider;
use SwagPayseraCheckout\Service\WebToPay\WebToPayLoader;
use WebToPay;
use WebToPayException;

class PaymentRequestBuilder
{
    private $userNormalizer;
    private $pluginSettingsProvider;
    private $paymentRequestMapper;

    public function __construct(
        UserNormalizer $userNormalizer,
        PluginSettingsProvider $pluginSettingsProvider,
        PaymentRequestMapper $paymentRequestMapper
    ) {
        $this->userNormalizer = $userNormalizer;
        $this->pluginSettingsProvider = $pluginSettingsProvider;
        $this->paymentRequestMapper = $paymentRequestMapper;
    }

    /**
     * @param string $orderNumber
     * @param array $userData
     * @param string $acceptUrl
     * @param string $cancelUrl
     * @param string $callbackUrl
     * @param float $amount
     * @param string $currency
     * @param string $paymentHash
     * @param string $uniquePaymentId
     * @param int|null $shopId
     * @return string
     * @throws WebToPayException|ProjectSettingsException
     */
    public function getPaymentRequestUrl(
        string $orderNumber,
        array $userData,
        string $acceptUrl,
        string $cancelUrl,
        string $callbackUrl,
        float $amount,
        string $currency,
        string $paymentHash,
        string $uniquePaymentId,
        ?int $shopId
    ): string {
        WebToPayLoader::loadWebToPay();

        $requestData = $this->paymentRequestMapper->mapRequestData(
            $this->userNormalizer->mapToUser($userData),
            $this->pluginSettingsProvider->getProjectSettingsByShopId($shopId ?? null),
            $orderNumber,
            $acceptUrl,
            $cancelUrl,
            $callbackUrl,
            $amount,
            $currency,
            $paymentHash,
            $uniquePaymentId,
            $shopId
        );

        $request = WebToPay::buildRequest($requestData);

        return WebToPay::PAY_URL . '?data=' . $request['data'] . '&sign=' . $request['sign'];
    }
}
