<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Entity;

class PluginSettings
{
    /**
     * @var int
     */
    private $projectId;

    /**
     * @var string
     */
    private $projectSign;

    /**
     * @var bool
     */
    private $test;

    public function __construct()
    {
        $this->test = false;
    }

    public function getProjectId(): int
    {
        return $this->projectId;
    }

    public function setProjectId(int $projectId): self
    {
        $this->projectId = $projectId;

        return $this;
    }

    public function getProjectSign(): string
    {
        return $this->projectSign;
    }

    public function setProjectSign(string $projectSign): self
    {
        $this->projectSign = $projectSign;

        return $this;
    }

    public function isTestEnabled(): bool
    {
        return $this->test;
    }

    public function setTest(bool $test): self
    {
        $this->test = $test;

        return $this;
    }
}
