<?php

declare(strict_types=1);

namespace SwagPayseraCheckout\Entity;

class PaymentRequest
{
    public const PAYMENT_HASH_KEY = 'payment_hash';
    public const SHOP_ID_KEY = 'shop_id';
    public const UNIQUE_PAYMENT_ID = 'unique_payment_id';

    /**
     * @var string
     */
    private $orderId;

    /**
     * @var int
     */
    private $amount;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var string
     */
    private $paymentHash;

    /**
     * @var string
     */
    private $uniquePaymentId;

    /**
     * @var int
     */
    private $status;

    /**
     * @var string
     */
    private $type;

    /**
     * @var int|null
     */
    private $payAmount;

    /**
     * @var string|null
     */
    private $payCurrency;

    public function getOrderId(): string
    {
        return $this->orderId;
    }

    public function setOrderId(string $orderId): self
    {
        $this->orderId = $orderId;

        return $this;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }

    public function setAmount(int $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public function setCurrency(string $currency): self
    {
        $this->currency = $currency;

        return $this;
    }

    public function getPaymentHash(): string
    {
        return $this->paymentHash;
    }

    public function setPaymentHash(string $paymentHash): self
    {
        $this->paymentHash = $paymentHash;

        return $this;
    }

    public function getUniquePaymentId(): string
    {
        return $this->uniquePaymentId;
    }

    public function setUniquePaymentId(string $uniquePaymentId): self
    {
        $this->uniquePaymentId = $uniquePaymentId;

        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getPayAmount(): ?int
    {
        return $this->payAmount;
    }

    public function setPayAmount(int $payAmount): self
    {
        $this->payAmount = $payAmount;

        return $this;
    }

    public function getPayCurrency(): ?string
    {
        return $this->payCurrency;
    }

    public function setPayCurrency(string $payCurrency): self
    {
        $this->payCurrency = $payCurrency;

        return $this;
    }
}
