{**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 *}
<link href="{$backOfficeCssUrl|escape:'htmlall':'UTF-8'}" rel="stylesheet" type="text/css">

<div class="container">
    <div class="row">
        <div class="col-md-12">
            <img class="paysera-logo" src="{$imageDirectory}paysera.svg" alt="Paysera" title="Paysera" style="margin-top: 5rem; margin-top: 5rem"/>
            <h1>{l s='text_about' mod='paysera'}</h1>
            <p>{l s='text_about_content' tags=[$payseraUrl] mod='paysera'}</p>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <h1>{l s='text_getting_started' mod='paysera'}</h1>
            <p>{l s='text_getting_started_content' mod='paysera'}</p>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="col-md-6">
                <h2>{l s='text_payment' mod='paysera'}</h2>
                <p>{l s='text_payment_content' mod='paysera'}</p>
            </div>
            <div class="col-md-6">
                <h2>{l s='text_delivery' mod='paysera'}</h2>
                <p>{l s='text_delivery_content' mod='paysera'}</p>
            </div>
        </div>
        <div class="col-md-12">
            <div class="col-md-6">
                {$payseraPaymentUrl}
                <br/>
                {$payseraPaymentBasic}
            </div>
            <div class="col-md-6">
                {$payseraDeliveryService}
                <br/>
                {$payseraDeliveryBasic}
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="col-md-6">
                <h2>{l s='text_need_assistance' mod='paysera'}</h2>
                <p>
                    {l s='text_need_assistance_content_client_support' mod='paysera'}<br/>
                    {l s='text_need_assistance_content_client_support_number' mod='paysera'}<br/>
                    {l s='text_need_assistance_content_client_support_email' mod='paysera'}<br/>
                    {l s='text_need_assistance_content_languages' tags=[$payseraContactUrl] mod='paysera'}<br/>
                    {l s='text_need_assistance_content_socialmedia' tags=[$payseraFacebookUrl, $payseraTwitterUrl] mod='paysera'}
                </p>
            </div>
            <div class="col-md-6">
                <h2>{l s='text_explore' mod='paysera'}</h2>
                    {l s='text_explore_content_intro' mod='paysera'}
                <br/>
                <ul>
                    <li>{l s='text_explore_content_listitem_1' mod='paysera'}</li>
                    <li>{l s='text_explore_content_listitem_2' mod='paysera'}</li>
                    <li>{l s='text_explore_content_listitem_3' tags=[$payseraIbanUrl] mod='paysera'}</li>
                    <li>{l s='text_explore_content_listitem_4' tags=[$payseraCardVisaUrl, $payseraGooglePlayUrl, $payseraApplePlayUrl] mod='paysera'}</li>
                </ul>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            {l s='text_explore_content_outro' tags=[$payseraMobileAppUrl] mod='paysera'}<br>
            {l s='text_explore_content_thank_you' mod='paysera'}
        </div>
    </div>
</div>
