<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */
namespace Paysera\Normalizer;

if (!defined('_PS_VERSION_')) {
    exit;
}

class TabNormalizer
{
    /**
     * @param array $data
     * @return \Tab
     */
    public function mapToEntity(array $data)
    {
        $tab = new \Tab();
        $tab->name = [];
        $tab->module = $data['module'];
        $tab->class_name = $data['class_name'];
        $tab->id_parent = \Tab::getIdFromClassName($data['parent_id']);

        /**
         * @var array<string, string> $language
         */
        foreach (\Language::getLanguages() as $language) {
            $tab->name[$language['id_lang']] =
                isset($data['languages'][$language['iso_code']]) === true ?
                    $data['languages'][$language['iso_code']] :
                    $data['name']
            ;
        }

        return $tab;
    }
}
