<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */
namespace Paysera\Helper;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Form\AdminFormInterface;

class FormHelper implements FormHelperInterface
{
    /**
     * @param string $key
     * @param array $translations
     * @param bool $requirement
     *
     * @return array
     */
    public function getTextForm($key, $translations, $requirement = false)
    {
        return [
            'type' => 'text',
            'label' => $translations['label'],
            'name' => $key,
            'required' => $requirement,
            'desc' => $translations['desc'],
        ];
    }

    /**
     * @param string $key
     * @param array $translations
     * @param bool $requirement
     *
     * @return array
     */
    public function getTextareaForm($key, $translations, $requirement = false, $rows = 10)
    {
        return [
            'type' => 'textarea',
            'label' => $translations['label'],
            'name' => $key,
            'rows' => $rows,
            'required' => $requirement,
            'desc' => $translations['desc'],
        ];
    }

    /**
     * @param string $key
     * @param array $translations
     * @param bool $requirement
     *
     * @return array
     */
    public function getBoolForm($key, $translations, $requirement = false)
    {
        return [
            'type' => 'switch',
            'label' => $translations['label'],
            'name' => $key,
            'required' => $requirement,
            'desc' => $translations['desc'],
            'class' => 'fixed-width-xxl',
            'is_bool' => true,
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                ],
            ],
        ];
    }

    /**
     * @param string $key
     * @param array $translations
     * @param array $selectList
     * @param bool $requirement
     * @param bool $multiple
     *
     * @return array
     */
    public function getSelectForm($key, $translations, $selectList, $requirement = false, $multiple = false)
    {
        $selectForm = [
            'type' => 'select',
            'label' => $translations['label'],
            'name' => $key,
            'required' => $requirement,
            'desc' => $translations['desc'],
            'class' => 'fixed-width-xxl',
            'multiple' => $multiple,
            'options' => [
                'query' => $selectList,
                'id' => 'id',
                'name' => 'name',
            ],
        ];

        if ($selectForm['multiple']) {
            $selectForm['size'] = 21;
        }

        return $selectForm;
    }

    /**
     * @param AdminFormInterface $form
     * @param string $table
     * @param string $identifier
     * @return string
     */
    public function generateFormOutput(AdminFormInterface $form, $table, $identifier)
    {
        $context = \Context::getContext();
        $lang = new \Language((int) \Configuration::get('PS_LANG_DEFAULT'));
        $helper = new \HelperForm();
        $helper->table = $table;
        $helper->show_toolbar = false;
        $helper->default_form_language = $lang->id;

        if (\Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG')) {
            $helper->allow_employee_form_lang = \Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        } else {
            $helper->allow_employee_form_lang = 0;
        }

        $helper->id = (int) \Tools::getValue('id_carrier');
        $helper->identifier = $identifier;
        $helper->submit_action = $form->getSubmitActionName();
        $helper->currentIndex = $context->link->getAdminLink('AdminPayseraConfiguration');
        $helper->token = \Tools::getAdminTokenLite('AdminPayseraConfiguration');
        $helper->tpl_vars = [
            'fields_value' => $form->getFieldsValue(),
            'languages' => $context->controller->getLanguages(),
            'id_language' => $context->language->id,
        ];

        return $helper->generateForm($form->getFormFields());
    }
}
