<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminPayseraPaymentDeliveryTabController extends ModuleAdminController
{
    /**
     * @var string
     */
    public $php_self;

    public function __construct()
    {
        parent::__construct();

        $this->bootstrap = true;
        $this->php_self = 'AdminPayseraConfiguration';
    }

    /**
     * @return void
     */
    public function initContent()
    {
        parent::initContent();

        if ($this->isDeliveryModuleEnabled()) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules')
                . '&configure=' . Paysera::PAYSERA_DELIVERY_MODULE_NAME)
            ;
        }
    }

    /**
     * @return string
     */
    public function renderList()
    {
        parent::renderList();

        $this->context->smarty->assign([
            'isEnabled' => $this->isDeliveryModuleEnabled(),
            'isUploaded' => $this->isDeliveryPluginUploaded(),
            'enableLink' => $this->context->link->getAdminLink('AdminModules')
                . '&enable=1&module_name=' . Paysera::PAYSERA_DELIVERY_MODULE_NAME
                . '&configure=' . Paysera::PAYSERA_DELIVERY_MODULE_NAME,
            'enableLinkLabel' => $this->l('enable_plugin'),
            'uploadLink' => $this->context->link->getAdminLink('AdminModules'),
            'uploadLinkLabel' => $this->l('upload_plugin'),
            'moduleUrl' => 'https://support.paysera.com/index.php?/payseraeng/Knowledgebase/Article/View/3548/0/prestashop-delivery',
        ]);

        return $this->module->display(
            _PS_MODULE_DIR_ . '/' . $this->module->name,
            'views/templates/admin/delivery_module.tpl'
        );
    }

    /**
     * @return bool
     */
    private function isDeliveryPluginUploaded()
    {
        return is_dir(_PS_MODULE_DIR_ . '/' . Paysera::PAYSERA_DELIVERY_MODULE_NAME);
    }

    /**
     * @return bool
     */
    private function isDeliveryModuleEnabled()
    {
        return Module::isEnabled(Paysera::PAYSERA_DELIVERY_MODULE_NAME);
    }
}
