<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */

use Paysera\Form\AdditionsSettingsForm;
use Paysera\Form\ExtraSettingsForm;
use Paysera\Form\GeneralSettingsForm;
use Paysera\Form\StatusSettingsForm;
use Paysera\Helper\FormHelper;
use Paysera\Service\Renderer\FormRenderer;

if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminPayseraConfigurationController extends ModuleAdminController
{
    /**
     * @var string
     */
    private $selectedTab;

    public function __construct()
    {
        parent::__construct();
        $this->bootstrap = true;
        $this->php_self = 'AdminPayseraConfiguration';
        $this->className = 'Configuration';
        $this->table = 'configuration';
        $this->selectedTab = null;
    }

    public function renderList()
    {
        $backOfficeJsUrl = __PS_BASE_URI__ . 'modules/' . $this->module->name . '/views/js/backoffice.js';
        $backOfficeCssUrl = __PS_BASE_URI__ . 'modules/' . $this->module->name . '/views/css/backoffice.css';

        $tplVars = [
            'settingsTitle' => $this->l('Configuration'),
            'settingsTabs' => $this->getSettingsTabs(),
            'selectedTab' => $this->getSelectedTab(),
            'backOfficeJsUrl' => $backOfficeJsUrl,
            'backOfficeCssUrl' => $backOfficeCssUrl,
        ];

        if (isset($this->context->cookie->payseraConfigMessage)) {
            $tplVars['message']['success'] = $this->context->cookie->payseraMessageSuccess;
            $tplVars['message']['text'] = $this->context->cookie->payseraConfigMessage;
            unset($this->context->cookie->payseraConfigMessage);
        } else {
            $tplVars['message'] = false;
        }

        $this->context->smarty->assign($tplVars);

        return $this->module->display(
            _PS_MODULE_DIR_ . '/' . $this->module->name,
            'views/templates/admin/tabs.tpl'
        );
    }

    protected function getSettingsTabs()
    {
        $tabs = [];
        $formHelper = new FormHelper();
        $generalSettingsForm = new GeneralSettingsForm(
            $formHelper,
            $this->module
        );

        $tabs[] = [
            'id' => $generalSettingsForm->getFormId(),
            'title' => $generalSettingsForm->getFormTitle(),
            'content' => (new FormRenderer(
                $generalSettingsForm,
                $this->table,
                $this->identifier,
                [$this, 'setSelectedTabName']
            ))->render(),
        ];

        $payseraProjectID = Configuration::get('PAYSERA_GENERAL_PROJECT_ID');

        if (!empty($payseraProjectID)) {
            $extraSettingsForm = new ExtraSettingsForm(
                $formHelper,
                $this->module
            );

            $tabs[] = [
                'id' => $extraSettingsForm->getFormId(),
                'title' => $extraSettingsForm->getFormTitle(),
                'content' => (new FormRenderer(
                    $extraSettingsForm,
                    $this->table,
                    $this->identifier,
                    [$this, 'setSelectedTabName']
                ))->render(),
            ];

            $statusSettingsForm = new StatusSettingsForm(
                $formHelper,
                $this->module
            );

            $tabs[] = [
                'id' => $statusSettingsForm->getFormId(),
                'title' => $statusSettingsForm->getFormTitle(),
                'content' => (new FormRenderer(
                    $statusSettingsForm,
                    $this->table,
                    $this->identifier,
                    [$this, 'setSelectedTabName']
                ))->render(),
            ];

            $additionsSettingsForm = new AdditionsSettingsForm(
                $formHelper,
                $this->module
            );

            $tabs[] = [
                'id' => $additionsSettingsForm->getFormId(),
                'title' => $additionsSettingsForm->getFormTitle(),
                'content' => (new FormRenderer(
                    $additionsSettingsForm,
                    $this->table,
                    $this->identifier,
                    [$this, 'setSelectedTabName']
                ))->render(),
            ];
        }

        return $tabs;
    }

    public function setSelectedTabName($tabName)
    {
        $this->selectedTab = $tabName;
    }

    /**
     * @return string
     */
    protected function getSelectedTab()
    {
        if ($this->selectedTab) {
            return $this->selectedTab;
        }

        if (Tools::getValue('selected_tab')) {
            return Tools::getValue('selected_tab');
        }

        return (new GeneralSettingsForm(new FormHelper(), $this->module))->getFormId();
    }
}
