<?php

declare (strict_types=1);
namespace Paysera\Scoped;

/**
 * Interface for sign checker
 */
interface WebToPay_Sign_SignCheckerInterface
{
    /**
     * Checks whether request is signed properly
     *
     * @param array<string, mixed> $request
     *
     * @return boolean
     */
    public function checkSign(array $request) : bool;
}
/**
 * Interface for sign checker
 */
\class_alias('Paysera\\Scoped\\WebToPay_Sign_SignCheckerInterface', 'WebToPay_Sign_SignCheckerInterface', \false);
