<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */
namespace Paysera\Service\Provider;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Repository\ConfigurationRepository;

class SpecificCountriesConfigurationProvider
{
    /**
     * @var ConfigurationRepository
     */
    private $configurationRepository;

    public function __construct($configurationRepository)
    {
        $this->configurationRepository = $configurationRepository;
    }

    /**
     * @return array<int,string>|null
     */
    public function get()
    {
        $countries = $this->configurationRepository->getSpecificCountriesGroup();

        $countries = array_filter(
            $countries,
            function ($item) {
                return $item !== '';
            }
        );

        return count($countries) > 0 ? array_values($countries) : null;
    }
}
