<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */
namespace Paysera\Helper;

if (!defined('_PS_VERSION_')) {
    exit;
}

namespace Paysera\Helper;

use Paysera\Form\AdminFormInterface;

interface FormHelperInterface
{
    /**
     * @param string $key
     * @param array $translations
     * @param bool $requirement
     *
     * @return array
     */
    public function getTextForm($key, $translations, $requirement = false);

    /**
     * @param string $key
     * @param array $translations
     * @param bool $requirement
     *
     * @return array
     */
    public function getTextareaForm($key, $translations, $requirement = false);

    /**
     * @param string $key
     * @param array $translations
     * @param bool $requirement
     *
     * @return array
     */
    public function getBoolForm($key, $translations, $requirement = false);

    /**
     * @param string $key
     * @param array $translations
     * @param array $selectList
     * @param bool $requirement
     * @param bool $multiple
     *
     * @return array
     */
    public function getSelectForm($key, $translations, $selectList, $requirement = false, $multiple = false);

    /**
     * @param AdminFormInterface $form
     * @param string $table
     * @param string $identifier
     * @return string
     */
    public function generateFormOutput(AdminFormInterface $form, $table, $identifier);
}
