<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of Paysera
 */
namespace Paysera\Form;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Entity\FormResult;
use Paysera\Helper\FormHelperInterface;

class AdditionsSettingsForm implements AdminFormInterface
{
    /**
     * @var FormHelperInterface
     */
    private $formHelper;
    /**
     * @var \Module
     */
    private $module;
    /**
     * @var string
     */
    private $formId;

    public function __construct(FormHelperInterface $formHelper, \Module $module)
    {
        $this->formHelper = $formHelper;
        $this->module = $module;
        $this->formId = 'AdditionsSettingsForm';
    }

    /**
     * @return FormResult
     */
    public function validate()
    {
        return new FormResult(true, '');
    }

    /**
     * @return FormResult
     */
    public function update()
    {
        \Configuration::updateValue(
            'PAYSERA_ADDITIONS_QUALITY_SIGN',
            \Tools::getValue('PAYSERA_ADDITIONS_QUALITY_SIGN')
        );
        \Configuration::updateValue(
            'PAYSERA_ADDITIONS_OWNERSHIP',
            \Tools::getValue('PAYSERA_ADDITIONS_OWNERSHIP')
        );
        \Configuration::updateValue(
            'PAYSERA_ADDITIONS_OWNERSHIP_CODE',
            trim(\Tools::getValue('PAYSERA_ADDITIONS_OWNERSHIP_CODE'))
        );

        if ('PAYSERA_SUCCESS_ADDITIONS_SETTING' === $this->module->l('PAYSERA_SUCCESS_ADDITIONS_SETTING')) {
            $successMessage = 'Your Paysera project additions settings were successfully updated.';
        } else {
            $successMessage = $this->module->l('PAYSERA_SUCCESS_ADDITIONS_SETTING');
        }

        return new FormResult(true, $successMessage);
    }

    public function getFormFields()
    {
        $translations = $this->getTranslations();

        return [[
            'form' => [
                'input' => [
                    $this->formHelper->getBoolForm(
                        'PAYSERA_ADDITIONS_QUALITY_SIGN',
                        $translations['quality']
                    ),
                    $this->formHelper->getBoolForm(
                        'PAYSERA_ADDITIONS_OWNERSHIP',
                        $translations['ownership']
                    ),
                    $this->formHelper->getTextForm(
                        'PAYSERA_ADDITIONS_OWNERSHIP_CODE',
                        $translations['ownership_code']
                    ),
                ],
                'submit' => [
                    'title' => $translations['save'],
                ],
            ],
        ]];
    }

    /**
     * @return array
     */
    public function getFieldsValue()
    {
        $configQuality = \Configuration::get('PAYSERA_ADDITIONS_QUALITY_SIGN');
        $configOwnership = \Configuration::get('PAYSERA_ADDITIONS_OWNERSHIP');
        $configOwnershipCode = trim(\Configuration::get('PAYSERA_ADDITIONS_OWNERSHIP_CODE'));

        $additionsSetting = [];
        $additionsSetting['PAYSERA_ADDITIONS_QUALITY_SIGN'] =
            \Tools::getValue('PAYSERA_ADDITIONS_QUALITY_SIGN', $configQuality)
        ;
        $additionsSetting['PAYSERA_ADDITIONS_OWNERSHIP'] =
            \Tools::getValue('PAYSERA_ADDITIONS_OWNERSHIP', $configOwnership)
        ;
        $additionsSetting['PAYSERA_ADDITIONS_OWNERSHIP_CODE'] =
            \Tools::getValue('PAYSERA_ADDITIONS_OWNERSHIP_CODE', $configOwnershipCode)
        ;

        return $additionsSetting;
    }

    public function additionalHTML()
    {
        return '';
    }

    /**
     * @return array
     */
    private function getTranslations()
    {
        $translations = [];

        if ('PAYSERA_ADDITIONS_QUALITY_SIGN' === $this->module->l('PAYSERA_ADDITIONS_QUALITY_SIGN')) {
            $translations['quality']['label'] = 'Quality sign';
        } else {
            $translations['quality']['label'] = $this->module->l('PAYSERA_ADDITIONS_QUALITY_SIGN');
        }
        if ('PAYSERA_ADDITIONS_OWNERSHIP' === $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP')) {
            $translations['ownership']['label'] = 'Ownership of website';
        } else {
            $translations['ownership']['label'] = $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP');
        }
        if ('PAYSERA_ADDITIONS_OWNERSHIP_CODE' === $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP_CODE')) {
            $translations['ownership_code']['label'] = 'Ownership code';
        } else {
            $translations['ownership_code']['label'] = $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP_CODE');
        }

        if ('PAYSERA_ADDITIONS_QUALITY_SIGN_DESC' === $this->module->l('PAYSERA_ADDITIONS_QUALITY_SIGN_DESC')) {
            $translations['quality']['desc'] = 'Enable this to use quality sign';
        } else {
            $translations['quality']['desc'] = $this->module->l('PAYSERA_ADDITIONS_QUALITY_SIGN_DESC');
        }
        if ('PAYSERA_ADDITIONS_OWNERSHIP_DESC' === $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP_DESC')) {
            $translations['ownership']['desc'] = 'Enable this to place ownership code';
        } else {
            $translations['ownership']['desc'] = $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP_DESC');
        }
        if ('PAYSERA_ADDITIONS_OWNERSHIP_CODE_DESC' === $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP_CODE_DESC')) {
            $translations['ownership_code']['desc'] = 'Enter ownership code';
        } else {
            $translations['ownership_code']['desc'] = $this->module->l('PAYSERA_ADDITIONS_OWNERSHIP_CODE_DESC');
        }
        if ('BACKEND_ADDITIONS_SAVE' === $this->module->l('BACKEND_ADDITIONS_SAVE')) {
            $translations['save'] = 'Save project additions settings';
        } else {
            $translations['save'] = $this->module->l('BACKEND_ADDITIONS_SAVE');
        }

        return $translations;
    }

    public function getFormId()
    {
        return $this->formId;
    }

    public function getFormTitle()
    {
        return $this->module->l('Project additions');
    }

    public function getSubmitActionName()
    {
        return 'btnAdditionsSubmit';
    }

    public function getFormHelper()
    {
        return $this->formHelper;
    }
}
