<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminPayseraPaymentAboutTabController extends ModuleAdminController
{
    /**
     * @var string
     */
    public $php_self;

    public function __construct()
    {
        parent::__construct();
        $this->bootstrap = true;
        $this->toolbar_title = 'About';
        $this->meta_title = 'About';

        $this->php_self = 'AdminPayseraConfiguration';
    }

    /**
     * @return string
     */
    public function renderList()
    {
        $this->context->smarty->assign([
            'imageDirectory' => _MODULE_DIR_ . $this->module->name . '/views/img/',
            'payseraPaymentUrl' => $this->formatLink($this->l('text_readmore'), $this->l('link_payment_gateway_checkout')),
            'payseraPaymentBasic' => $this->formatLink($this->l('text_instructions'), $this->l('link_checkout_basic')),
            'payseraDeliveryService' => $this->formatLink($this->l('text_readmore'), $this->l('link_delivery_service')),
            'payseraDeliveryBasic' => $this->formatLink($this->l('text_instructions'), $this->l('link_delivery_basic')),
            'payseraContactUrl' => $this->formatLink($this->l('text_contactus'), $this->l('link_contactus')),
            'payseraFacebookUrl' => $this->formatLink($this->l('text_facebook'), $this->l('link_facebook')),
            'payseraTwitterUrl' => $this->formatLink($this->l('text_twitter'), $this->l('link_twitter')),
            'payseraUrl' => $this->formatLink($this->l('text_paysera_title'), $this->l('link_page_paysera')),
            'payseraIbanUrl' => $this->formatLink($this->l('text_iban'), $this->l('link_iban_account')),
            'payseraCardVisaUrl' => $this->formatLink($this->l('text_visa_card'), $this->l('link_visa_card')),
            'payseraGooglePlayUrl' => $this->formatLink($this->l('text_google_pay'), $this->l('link_google_pay')),
            'payseraApplePlayUrl' => $this->formatLink($this->l('text_apple_pay'), $this->l('link_apple_pay')),
            'payseraMobileAppUrl' => $this->formatLink($this->l('text_mobile_app'), $this->l('link_mobile_application')),
            'backOfficeCssUrl' => __PS_BASE_URI__ . 'modules/' . $this->module->name . '/views/css/delivery.css',
        ]);

        return $this->module->display(
            _PS_MODULE_DIR_ . '/' . $this->module->name,
            'views/templates/admin/about.tpl'
        );
    }

    /**
     * @param string $name
     * @param string $link
     * @return string
     */
    private function formatLink($name, $link)
    {
        return sprintf('<a href="%s" target="_blank" rel="noopener noreferrer">%s</a>', $link, $name);
    }
}
