<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Delivery\Model\ShipmentRequestModel;

/**
 * Execute the upgrade for version 1.5.3
 *
 * @param PayseraDelivery $module
 * @return bool
 */
function upgradeModule153($module)
{
    try {
        Db::getInstance()->execute(
            'ALTER TABLE `' . ShipmentRequestModel::PREFIXED_TABLE_NAME . '` ADD `delivery_order_api_id` VARCHAR(255) NULL AFTER `order_id`'
        );
    } catch (Exception $e) {
        $module->getServiceContainer()
            ->getService('paysera.payseradelivery.service.logger')
            ->error($e->getMessage())
        ;
        return false;
    }

    $module->registerHook('payseraPaymentConfirmed');

    return true;
}
