<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\Service;

if (!defined('_PS_VERSION_')) {
    exit;
}

class Logger
{
    private const ERROR_PREFIX = 'Paysera Delivery Error: ';
    private const INFO_PREFIX = 'Paysera Delivery Info: ';

    public function error(string $errorMessage, ?\Exception $exception = null): bool
    {
        $message = sprintf('%s%s', self::ERROR_PREFIX, $errorMessage);

        if ($exception !== null) {
            $message .= ' ' . $exception->getMessage();
        }

        return \PrestaShopLogger::addLog($message, 3);
    }

    public function info(string $message): bool
    {
        $message = sprintf('%s%s', self::INFO_PREFIX, $message);

        return \PrestaShopLogger::addLog($message, 1);
    }
}
