<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery;

/**
 * Interface for handling order-related hooks.
 */
interface OrderHookHandlerInterface
{
    /**
     * Handle the order confirmation hook.
     *
     * @param array $parameters Parameters passed to the hook.
     */
    public function handleHookOrderConfirmation(array $parameters): void;

    /**
     * Handle the order status post-update hook.
     *
     * @param array $parameters Parameters passed to the hook.
     */
    public function handleHookActionOrderStatusPostUpdate(array $parameters): void;

    /**
     * Handle the Paysera payment confirmed hook.
     *
     * @param array $parameters Parameters passed to the hook.
     */
    public function handleHookPayseraPaymentConfirmed(array $parameters): void;
}
